/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.world;

import eu.ha3.presencefootsteps.sound.Isolator;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.world.Association;
import eu.ha3.presencefootsteps.world.Emitter;
import eu.ha3.presencefootsteps.world.Solver;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3614;
import net.minecraft.class_745;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PFSolver
implements Solver {
    private static final Logger logger = LogManager.getLogger((String)"PFSolver");
    private static final double TRAP_DOOR_OFFSET = 0.1;
    private final Isolator isolator;

    public PFSolver(Isolator isolator) {
        this.isolator = isolator;
    }

    @Override
    public void playAssociation(class_1309 ply, Association assos, State eventType) {
        if (assos.isNotEmitter()) {
            return;
        }
        if ((assos = assos.at(ply)).hasAssociation()) {
            this.isolator.getAcoustics().playAcoustic(assos, eventType, Options.EMPTY);
        } else {
            this.isolator.getStepPlayer().playStep(assos);
        }
    }

    @Override
    public Association findAssociation(class_1309 ply, double verticalOffsetAsMinus, boolean isRightFoot) {
        double rot = Math.toRadians(class_3532.method_15393((float)ply.method_36454()));
        class_243 pos = ply.method_19538();
        float feetDistanceToCenter = 0.2f * (float)(isRightFoot ? -1 : 1);
        return this.findAssociation((class_1297)ply, new class_2338(pos.field_1352 + Math.cos(rot) * (double)feetDistanceToCenter, ply.method_5829().method_1001(class_2350.class_2351.field_11052) - 0.1 - verticalOffsetAsMinus, pos.field_1350 + Math.sin(rot) * (double)feetDistanceToCenter));
    }

    private Association findAssociation(class_1297 player, class_2338 pos) {
        boolean isXdangMax;
        Association worked;
        class_243 vel;
        if (!(player instanceof class_745) && (vel = player.method_18798()).method_1027() != 0.0 && Math.abs(vel.field_1351) < 0.004) {
            return Association.NOT_EMITTER;
        }
        class_238 collider = player.method_5829();
        collider = collider.method_989(0.0, -(collider.field_1322 - Math.floor(collider.field_1322)), 0.0);
        double expansionRatio = 0.1;
        collider = collider.method_1014(expansionRatio);
        if (player.method_5624()) {
            collider = collider.method_1009(0.3, 0.5, 0.3);
        }
        if (!(worked = this.findAssociation(player.field_6002, pos, collider)).isNull()) {
            return worked;
        }
        double xdang = (player.method_23317() - (double)pos.method_10263()) * 2.0 - 1.0;
        double zdang = (player.method_23321() - (double)pos.method_10260()) * 2.0 - 1.0;
        if (Math.max(Math.abs(xdang), Math.abs(zdang)) <= (double)0.2f) {
            return worked;
        }
        boolean bl = isXdangMax = Math.abs(xdang) > Math.abs(zdang);
        worked = isXdangMax ? this.findAssociation(player.field_6002, pos.method_10089(xdang > 0.0 ? 1 : -1), collider) : this.findAssociation(player.field_6002, pos.method_10077(zdang > 0.0 ? 1 : -1), collider);
        if (!worked.isNull()) {
            return worked;
        }
        if (isXdangMax) {
            return this.findAssociation(player.field_6002, pos.method_10077(zdang > 0.0 ? 1 : -1), collider);
        }
        return this.findAssociation(player.field_6002, pos.method_10089(xdang > 0.0 ? 1 : -1), collider);
    }

    private String findForGolem(class_1937 world, class_2338 pos, String substrate) {
        String golem;
        List golems = world.method_8390(class_1297.class, new class_238(pos), e -> !(e instanceof class_1657));
        if (!golems.isEmpty() && Emitter.isEmitter(golem = this.isolator.getGolemMap().getAssociation(((class_1297)golems.get(0)).method_5864(), substrate))) {
            logger.debug("Golem detected: " + golem);
            return golem;
        }
        return "UNASSIGNED";
    }

    private Association findAssociation(class_1937 world, class_2338 pos, class_238 collider) {
        String wet;
        class_2680 in = world.method_8320(pos);
        class_2338 up = pos.method_10084();
        class_2680 above = world.method_8320(up);
        Object association = this.findForGolem(world, up, "carpet");
        if (!Emitter.isEmitter((String)association)) {
            association = this.isolator.getBlockMap().getAssociation(above, "carpet");
        }
        if (Emitter.isEmitter((String)association)) {
            logger.debug("Carpet detected: " + (String)association);
            pos = up;
            in = above;
        } else {
            String foliage;
            class_265 shape;
            class_3614 mat = in.method_26207();
            if (mat == class_3614.field_15959 || mat == class_3614.field_15924) {
                class_2338 down = pos.method_10074();
                class_2680 below = world.method_8320(down);
                association = this.isolator.getBlockMap().getAssociation(below, "bigger");
                if (Emitter.isResult((String)association)) {
                    logger.debug("Fence detected: " + (String)association);
                    pos = down;
                    in = below;
                }
            }
            if ((shape = in.method_26220((class_1922)world, pos)).method_1110()) {
                shape = in.method_26218((class_1922)world, pos);
            }
            if (!shape.method_1110() && !shape.method_1107().method_996(pos).method_994(collider)) {
                logger.debug("Skipping due to hitbox miss");
                return Association.NOT_EMITTER;
            }
            if (!Emitter.isResult((String)association) && !Emitter.isEmitter((String)(association = this.findForGolem(world, pos, "")))) {
                association = this.isolator.getBlockMap().getAssociation(in, "");
            }
            if (Emitter.isEmitter((String)association) && Emitter.isEmitter(foliage = this.isolator.getBlockMap().getAssociation(above, "foliage"))) {
                logger.debug("Foliage detected: " + foliage);
                association = (String)association + "," + foliage;
            }
        }
        if (Emitter.isEmitter((String)association) && (world.method_8520(up) || in.method_26227().method_15767(class_3486.field_15517) || above.method_26227().method_15767(class_3486.field_15517)) && Emitter.isEmitter(wet = this.isolator.getBlockMap().getAssociation(in, "wet"))) {
            logger.debug("Wet block detected: " + wet);
            association = (String)association + "," + wet;
        }
        if (Emitter.isNonEmitter((String)association)) {
            return Association.NOT_EMITTER;
        }
        if (Emitter.isResult((String)association)) {
            return new Association(in, pos).with((String)association);
        }
        if (in.method_26215()) {
            return Association.NOT_EMITTER;
        }
        class_2498 sounds = in.method_26231();
        String substrate = String.format(Locale.ENGLISH, "%.2f_%.2f", Float.valueOf(sounds.field_11540), Float.valueOf(sounds.field_11539));
        String primitive = this.isolator.getPrimitiveMap().getAssociation(sounds, substrate);
        if (Emitter.isNonEmitter(primitive)) {
            return Association.NOT_EMITTER;
        }
        return new Association(in, pos).with(primitive);
    }

    @Override
    public Association findAssociation(class_1937 world, class_2338 pos, String strategy) {
        if (!"find_messy_foliage".equals(strategy)) {
            return Association.NOT_EMITTER;
        }
        class_2680 above = world.method_8320(pos.method_10084());
        String foliage = this.isolator.getBlockMap().getAssociation(above, "foliage");
        if (!Emitter.isEmitter(foliage)) {
            return Association.NOT_EMITTER;
        }
        if ("MESSY_GROUND".equals(this.isolator.getBlockMap().getAssociation(above, "messy"))) {
            return new Association(above, pos.method_10084()).with(foliage);
        }
        return Association.NOT_EMITTER;
    }
}

